/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.EclipseConnection;
import com.parctechnologies.eclipse.EclipseEngineOptions;
import com.parctechnologies.eclipse.EmbeddedEclipse;
import com.parctechnologies.eclipse.Fail;
import com.parctechnologies.eclipse.Throw;
import java.io.File;

public class JEclipse {
    public static void main(String[] stringArray) throws Exception {
        JEclipse jEclipse = new JEclipse();
        jEclipse.start(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(String[] stringArray) throws Exception {
        EclipseEngineOptions eclipseEngineOptions = null;
        try {
            eclipseEngineOptions = this.createOptions();
        }
        catch (NoEclipseDirectoryException noEclipseDirectoryException) {
            System.err.println("Path of ECLiPSe installation must be specified using");
            System.err.println("system property \"eclipse.directory\", e.g.");
            System.err.println("UNIX: % java -Declipse.directory=/usr/local/eclipse JEclipse");
            System.err.println("Windows: C:\\> java -Declipse.directory=C:\\Eclipse JEclipse");
            System.exit(1);
        }
        try {
            this.setMemoryOptionsFromCommandLine(eclipseEngineOptions, stringArray);
        }
        catch (BadMemorySettingException badMemorySettingException) {
            System.err.println("Memory settings must be of the form:");
            System.err.println("          -g <memory size> (global stack)");
            System.err.println("          -l <memory size> (local stack)");
            System.err.println("  where <memory size> is <integer> (kilobytes) or <integer>M (megabytes). ");
            System.err.println("  Kilobyte settings will be rounded up to the nearest megabyte.");
            System.exit(1);
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "Embedded ECLiPSE";
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        eclipseEngineOptions.setCommandLineOptions(stringArray2);
        EmbeddedEclipse embeddedEclipse = EmbeddedEclipse.getInstance(eclipseEngineOptions);
        try {
            this.run_toplevel(embeddedEclipse);
        }
        catch (Fail fail) {
            System.exit(1);
        }
        catch (Throw throw_) {
            System.exit(2);
        }
        finally {
            embeddedEclipse.destroy();
            System.exit(0);
        }
    }

    protected void run_toplevel(EclipseConnection eclipseConnection) throws Exception {
        eclipseConnection.rpc("sepia_kernel:standalone_toplevel");
    }

    private EclipseEngineOptions createOptions() throws NoEclipseDirectoryException {
        File file;
        try {
            file = new File(System.getProperty("eclipse.directory"));
        }
        catch (NullPointerException nullPointerException) {
            throw new NoEclipseDirectoryException();
        }
        EclipseEngineOptions eclipseEngineOptions = new EclipseEngineOptions(file);
        eclipseEngineOptions.setUseQueues(false);
        return eclipseEngineOptions;
    }

    private void setMemoryOptionsFromCommandLine(EclipseEngineOptions eclipseEngineOptions, String[] stringArray) throws BadMemorySettingException {
        Integer n = this.findMemorySetting("-g", stringArray);
        Integer n2 = this.findMemorySetting("-l", stringArray);
        if (n != null) {
            eclipseEngineOptions.setGlobalSize(n);
        }
        if (n2 != null) {
            eclipseEngineOptions.setLocalSize(n2);
        }
    }

    private Integer findMemorySetting(String string, String[] stringArray) throws BadMemorySettingException {
        Integer n = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--")) {
                return n;
            }
            if (!stringArray[i].equals(string)) continue;
            if (i == stringArray.length - 1) {
                throw new BadMemorySettingException();
            }
            String string2 = stringArray[i + 1];
            try {
                int n2 = Integer.parseInt(string2);
                n = new Integer((int)Math.ceil((double)n2 / 1024.0));
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                if (!string2.endsWith("M")) {
                    throw new BadMemorySettingException();
                }
                try {
                    return new Integer(Integer.parseInt(string2.substring(0, string2.length() - 1)));
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new BadMemorySettingException();
                }
            }
        }
        return n;
    }

    class NoEclipseDirectoryException
    extends Exception {
        NoEclipseDirectoryException() {
        }
    }

    class BadMemorySettingException
    extends Exception {
        BadMemorySettingException() {
        }
    }
}

