/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import att.grappa.Element;
import com.parctechnologies.eclipse.visualisation.BatchGoal;
import com.parctechnologies.eclipse.visualisation.ElementType;
import com.parctechnologies.eclipse.visualisation.MultiViewletDataStore;
import com.parctechnologies.eclipse.visualisation.SymRef;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewletAction;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletDataImpl;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletFactory;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.ViewletRangeCollection;
import com.parctechnologies.eclipse.visualisation.ViewletType;
import com.parctechnologies.eclipse.visualisation.viewers.CustRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class MultiViewletType
implements ViewletType,
ViewletFactory {
    private SymRef symRef;
    private TableCellRenderer tableCellRenderer;
    private Collection viewletTypeCollection = new LinkedList();

    public MultiViewletType(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addViewletType((ViewletType)iterator.next());
        }
    }

    public void addViewletType(ViewletType viewletType) {
        this.viewletTypeCollection.add(viewletType);
    }

    public Collection getViewletTypeCollection() {
        return this.viewletTypeCollection;
    }

    @Override
    public boolean canBuildFrom(ElementType elementType) {
        return true;
    }

    @Override
    public ViewletData build() {
        ViewletType viewletType = (ViewletType)this.viewletTypeCollection.iterator().next();
        ViewletData viewletData = ((ViewletFactory)((Object)viewletType)).build();
        return new Data(viewletType, viewletData);
    }

    @Override
    public String getDescription() {
        return "Multi viewlet";
    }

    @Override
    public void setSymRef(SymRef symRef) {
        this.symRef = symRef;
        for (ViewletType viewletType : this.viewletTypeCollection) {
            viewletType.setSymRef(new SymRef(viewletType, this.getSymRef(), viewletType.getClass().getName()));
        }
    }

    @Override
    public SymRef getSymRef() {
        return this.symRef;
    }

    @Override
    public synchronized TableCellRenderer getTableCellRenderer() {
        if (this.tableCellRenderer == null) {
            this.tableCellRenderer = new CellRenderer();
        }
        return this.tableCellRenderer;
    }

    synchronized Class getCustomRendererClass() {
        return CustRenderer.class;
    }

    @Override
    public void customizeElement(ViewletDataStore viewletDataStore, List list, Element element) {
        Data data = (Data)viewletDataStore.getViewletDataAt(list);
        ViewletData viewletData = data.getViewletData();
        ViewletType viewletType = data.getViewletType();
        MultiViewletDataStore multiViewletDataStore = (MultiViewletDataStore)viewletDataStore;
        data.getViewletType().customizeElement(multiViewletDataStore.getViewletDataStore(data.getViewletType()), list, element);
    }

    private Map rangeToTypeRangeMap(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        Iterator iterator = viewletRange.iterator();
        HashMap<ViewletType, ViewletRange> hashMap = new HashMap<ViewletType, ViewletRange>();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Data data = (Data)viewletDataStore.getViewletDataAt(list);
            ViewletType viewletType = data.getViewletType();
            ViewletRange viewletRange2 = (ViewletRange)hashMap.get(viewletType);
            if (viewletRange2 == null) {
                viewletRange2 = new ViewletRangeCollection();
                hashMap.put(viewletType, viewletRange2);
            }
            viewletRange2.add(list);
        }
        return hashMap;
    }

    @Override
    public BatchGoal collectPreBuildGoal(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        BatchGoal batchGoal = new BatchGoal();
        Map map = this.rangeToTypeRangeMap(viewletDataStore, viewletRange);
        for (ViewletType viewletType : this.viewletTypeCollection) {
            ViewletRange viewletRange2 = (ViewletRange)map.get(viewletType);
            ViewletDataStore viewletDataStore2 = ((MultiViewletDataStore)viewletDataStore).getViewletDataStore(viewletType);
            if (viewletRange2 == null) {
                viewletRange2 = new ViewletRangeCollection();
            }
            batchGoal.add(viewletType.collectPreBuildGoal(viewer, viewletDataStore2, viewletRange2));
        }
        return batchGoal;
    }

    @Override
    public void startBuild(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, List list) {
        Map map = this.rangeToTypeRangeMap(viewletDataStore, viewletRange);
        Iterator iterator = list.iterator();
        for (ViewletType viewletType : this.viewletTypeCollection) {
            ViewletRange viewletRange2 = (ViewletRange)map.get(viewletType);
            ViewletDataStore viewletDataStore2 = ((MultiViewletDataStore)viewletDataStore).getViewletDataStore(viewletType);
            List list2 = (List)iterator.next();
            if (viewletRange2 == null) {
                viewletRange2 = new ViewletRangeCollection();
            }
            viewletType.startBuild(viewer, viewletDataStore2, viewletRange2, list2);
        }
    }

    @Override
    public void stopBuild() {
    }

    @Override
    public BatchGoal collectPreUpdateGoal(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, UpdateEvent updateEvent) {
        BatchGoal batchGoal = new BatchGoal();
        Map map = this.rangeToTypeRangeMap(viewletDataStore, viewletRange);
        for (ViewletType viewletType : this.viewletTypeCollection) {
            ViewletRange viewletRange2 = (ViewletRange)map.get(viewletType);
            ViewletDataStore viewletDataStore2 = ((MultiViewletDataStore)viewletDataStore).getViewletDataStore(viewletType);
            if (viewletRange2 == null) {
                viewletRange2 = new ViewletRangeCollection();
            }
            batchGoal.add(viewletType.collectPreUpdateGoal(viewer, viewletDataStore2, viewletRange2, updateEvent));
        }
        return batchGoal;
    }

    @Override
    public void startUpdate(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, List list, UpdateEvent updateEvent) {
        Map map = this.rangeToTypeRangeMap(viewletDataStore, viewletRange);
        Iterator iterator = list.iterator();
        for (ViewletType viewletType : this.viewletTypeCollection) {
            ViewletRange viewletRange2 = (ViewletRange)map.get(viewletType);
            ViewletDataStore viewletDataStore2 = ((MultiViewletDataStore)viewletDataStore).getViewletDataStore(viewletType);
            List list2 = (List)iterator.next();
            if (viewletRange2 == null) {
                viewletRange2 = new ViewletRangeCollection();
            }
            viewletType.startUpdate(viewer, viewletDataStore2, viewletRange2, list2, updateEvent);
        }
    }

    @Override
    public void stopUpdate(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
    }

    @Override
    public Collection getActions(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        Object object;
        LinkedList linkedList = new LinkedList();
        for (Object object2 : this.viewletTypeCollection) {
            Object object3 = ((MultiViewletDataStore)viewletDataStore).getViewletDataStore((ViewletType)object2);
            object = object3.createRange(viewletRange);
            linkedList.addAll(object2.getActions((ViewletDataStore)object3, (ViewletRange)object));
        }
        TreeMap treeMap = new TreeMap();
        for (Object object3 : linkedList) {
            object = (String)object3.getValue("Name");
            MultiAction multiAction = (MultiAction)treeMap.get(object);
            if (multiAction == null) {
                multiAction = new MultiAction((String)object, (Icon)object3.getValue("SmallIcon"));
                treeMap.put(object, multiAction);
            }
            multiAction.actions.add(object3);
        }
        return treeMap.values();
    }

    public static class Data
    extends ViewletDataImpl {
        private ViewletType viewletType;
        private ViewletData viewletData;

        public Data(ViewletType viewletType, ViewletData viewletData) {
            this.viewletType = viewletType;
            this.viewletData = viewletData;
        }

        public void setViewletData(ViewletData viewletData) {
            this.viewletData = viewletData;
        }

        public ViewletData getViewletData() {
            return this.viewletData;
        }

        public void setViewletType(ViewletType viewletType) {
            this.viewletType = viewletType;
        }

        public ViewletType getViewletType() {
            return this.viewletType;
        }

        @Override
        public boolean getHoldsOnUpdates() {
            return this.viewletData.getHoldsOnUpdates();
        }

        @Override
        public void setHoldsOnUpdates(boolean bl) {
            this.viewletData.setHoldsOnUpdates(bl);
        }

        public String toString() {
            return this.viewletData.toString();
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Data data = (Data)object;
            return data.getViewletType().getTableCellRenderer().getTableCellRendererComponent(jTable, data.getViewletData(), bl, bl2, n, n2);
        }
    }

    protected class MultiAction
    extends AbstractAction {
        Collection actions;

        public MultiAction(String string, Icon icon) {
            super(string);
            this.putValue("SmallIcon", icon);
            this.actions = new LinkedList();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (Action action : this.actions) {
                action.actionPerformed(actionEvent);
            }
        }
    }

    protected class ChangeTypeAction
    extends ViewletAction {
        protected ViewletDataStore viewletDataStore;
        protected ViewletRange viewletRange;
        protected Collection viewletTypeCollection;

        public ChangeTypeAction(Collection collection, ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
            super("Change type");
            this.putValue("Name", "Change type");
            this.putValue("LongDescription", "Change the type of viewlet at this location");
            this.putValue("ShortDescription", "Change type of viewlet");
            this.viewletTypeCollection = collection;
            this.viewletRange = viewletRange;
            this.viewletDataStore = viewletDataStore;
            this.setEnabled(false);
        }

        public void actionPerformed() {
        }
    }
}

