/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Grappa;
import att.grappa.GrappaConstants;
import att.grappa.GrappaSupport;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class PrintfParser
implements GrappaConstants {
    private boolean alternate;
    private boolean rightpad;
    private boolean sign;
    private boolean space;
    private boolean zeropad;
    private boolean trim;
    private int precision;
    private int width;
    private String plus;
    private char padding;
    private StringBuilder scratch = new StringBuilder();

    PrintfParser() {
    }

    final int parse(char[] cfmt) {
        return this.parse(cfmt, 0);
    }

    final int parse(char[] cfmt, int n) {
        char ch;
        this.alternate = false;
        this.rightpad = false;
        this.sign = false;
        this.space = false;
        this.zeropad = false;
        this.trim = false;
        boolean done = false;
        while (n < cfmt.length && !done) {
            switch (cfmt[n]) {
                case '-': {
                    this.rightpad = true;
                    break;
                }
                case '+': {
                    this.sign = true;
                    break;
                }
                case ' ': {
                    this.space = true;
                    break;
                }
                case '0': {
                    this.zeropad = true;
                    break;
                }
                case '#': {
                    this.alternate = true;
                    break;
                }
                default: {
                    done = true;
                    --n;
                }
            }
            ++n;
        }
        this.plus = this.sign ? "+" : (this.space ? " " : "");
        this.width = 0;
        while (n < cfmt.length && GrappaSupport.isdigit(ch = cfmt[n])) {
            this.width = this.width * 10 + (ch - 48);
            ++n;
        }
        if (n < cfmt.length && cfmt[n] == '.') {
            ++n;
            this.precision = 0;
            while (n < cfmt.length && GrappaSupport.isdigit(ch = cfmt[n])) {
                this.precision = this.precision * 10 + (ch - 48);
                ++n;
            }
        } else {
            this.precision = -1;
        }
        this.padding = (char)(this.zeropad && !this.rightpad ? 48 : 32);
        return n;
    }

    final StringBuilder buildChar(StringBuilder buf, int arg) {
        this.scratch.setLength(0);
        this.scratch.append((char)arg);
        return this.strpad(buf, this.scratch.toString(), 32, this.width, this.rightpad);
    }

    final StringBuilder buildExp(StringBuilder buf, double arg, boolean upper) {
        double base;
        double exp;
        this.precision = this.precision >= 0 ? this.precision : 6;
        double val = arg;
        int sign = val >= 0.0 ? 1 : -1;
        double d = val = val < 0.0 ? -val : val;
        if (val >= 1.0) {
            exp = Math.log(val) / LOG10;
            base = Math.pow(10.0, exp - (double)((int)exp));
        } else {
            exp = Math.log(val / 10.0) / LOG10;
            base = Math.pow(10.0, exp - (double)((int)exp) + 1.0);
        }
        this.scratch.setLength(0);
        this.scratch.append(upper ? "E" : "e");
        this.scratch.append(exp > 0.0 ? (char)'+' : '-');
        this.strpad(this.scratch, "" + (int)(exp > 0.0 ? exp : -exp), 48, 2, false);
        if (this.padding == '0' && this.precision >= 0) {
            this.padding = (char)32;
        }
        return this.strpad(buf, this.doubleToString((double)sign * base, this.scratch.toString()), this.padding, this.width, this.rightpad);
    }

    final StringBuilder buildFlex(StringBuilder buf, double arg, boolean upper) {
        StringBuilder retbuf;
        this.trim = true;
        double val = arg;
        double ival = (int)arg;
        val = val < 0.0 ? -val : val;
        double exp = val >= 1.0 ? Math.log(val) / LOG10 : Math.log(val / 10.0) / LOG10;
        int iexp = (int)exp;
        int n = this.precision = this.precision >= 0 ? (this.precision = this.precision - 1) : 5;
        if (val == ival) {
            if (this.alternate) {
                if (this.precision < 0 || iexp <= this.precision) {
                    this.precision -= iexp;
                    retbuf = this.buildFloat(buf, arg);
                } else {
                    retbuf = this.buildExp(buf, arg, upper);
                }
            } else if (this.precision < 0 || iexp <= this.precision) {
                this.precision = -1;
                retbuf = this.buildInteger(buf, (int)arg);
            } else {
                retbuf = this.buildExp(buf, arg, upper);
            }
        } else {
            retbuf = iexp < -4 || iexp > this.precision ? this.buildExp(buf, arg, upper) : this.buildFloat(buf, arg);
        }
        return retbuf;
    }

    final StringBuilder buildPoint(StringBuilder buf, Point2D parg, boolean upper) {
        double[] arg = new double[]{0.0, 0.0};
        double[] exp = new double[]{0.0, 0.0};
        double[] val = new double[]{0.0, 0.0};
        double[] ival = new double[]{0.0, 0.0};
        int[] iexp = new int[]{0, 0};
        StringBuilder retbuf = null;
        this.trim = true;
        arg[0] = parg.getX();
        arg[1] = Grappa.negateStringYCoord ? -parg.getY() : parg.getY();
        val[0] = arg[0];
        val[1] = arg[1];
        int orig_precision = this.precision;
        for (int i = 0; i < 2; ++i) {
            int n;
            this.precision = orig_precision;
            ival[i] = (int)val[i];
            val[i] = val[i] < 0.0 ? -val[i] : val[i];
            exp[i] = val[i] >= 1.0 ? Math.log(val[i]) / LOG10 : Math.log(val[i] / 10.0) / LOG10;
            iexp[i] = (int)exp[i];
            if (this.precision >= 0) {
                n = this.precision - 1;
                this.precision = this.precision;
            } else {
                n = this.precision = 5;
            }
            if (val[i] == ival[i]) {
                if (this.alternate) {
                    if (this.precision < 0 || iexp[i] <= this.precision) {
                        this.precision -= iexp[i];
                        retbuf = this.buildFloat(buf, arg[i]);
                    } else {
                        retbuf = this.buildExp(buf, arg[i], upper);
                    }
                } else if (this.precision < 0 || iexp[i] <= this.precision) {
                    this.precision = -1;
                    retbuf = this.buildInteger(buf, (long)arg[i]);
                } else {
                    retbuf = this.buildExp(buf, arg[i], upper);
                }
            } else {
                retbuf = iexp[i] < -4 || iexp[i] > this.precision ? this.buildExp(buf, arg[i], upper) : this.buildFloat(buf, arg[i]);
            }
            if (i != 0) continue;
            buf = retbuf = retbuf.append(',');
        }
        return retbuf;
    }

    final StringBuilder buildSize(StringBuilder buf, Dimension2D parg, boolean upper) {
        double[] arg = new double[]{0.0, 0.0};
        double[] exp = new double[]{0.0, 0.0};
        double[] val = new double[]{0.0, 0.0};
        double[] ival = new double[]{0.0, 0.0};
        int[] iexp = new int[]{0, 0};
        StringBuilder retbuf = null;
        this.trim = true;
        arg[0] = parg.getWidth();
        arg[1] = parg.getHeight();
        val[0] = arg[0];
        val[1] = arg[1];
        int orig_precision = this.precision;
        for (int i = 0; i < 2; ++i) {
            int n;
            this.precision = orig_precision;
            ival[i] = (int)val[i];
            val[i] = val[i] < 0.0 ? -val[i] : val[i];
            exp[i] = val[i] >= 1.0 ? Math.log(val[i]) / LOG10 : Math.log(val[i] / 10.0) / LOG10;
            iexp[i] = (int)exp[i];
            if (this.precision >= 0) {
                n = this.precision - 1;
                this.precision = this.precision;
            } else {
                n = this.precision = 5;
            }
            if (val[i] == ival[i]) {
                if (this.alternate) {
                    if (this.precision < 0 || iexp[i] <= this.precision) {
                        this.precision -= iexp[i];
                        retbuf = this.buildFloat(buf, arg[i]);
                    } else {
                        retbuf = this.buildExp(buf, arg[i], upper);
                    }
                } else if (this.precision < 0 || iexp[i] <= this.precision) {
                    this.precision = -1;
                    retbuf = this.buildInteger(buf, (long)arg[i]);
                } else {
                    retbuf = this.buildExp(buf, arg[i], upper);
                }
            } else {
                retbuf = iexp[i] < -4 || iexp[i] > this.precision ? this.buildExp(buf, arg[i], upper) : this.buildFloat(buf, arg[i]);
            }
            if (i != 0) continue;
            buf = retbuf = retbuf.append(',');
        }
        return retbuf;
    }

    final StringBuilder buildBox(StringBuilder buf, Rectangle2D parg, boolean upper, boolean dimensioned) {
        double[] arg = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] exp = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] val = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] ival = new double[]{0.0, 0.0, 0.0, 0.0};
        int[] iexp = new int[]{0, 0, 0, 0};
        StringBuilder retbuf = null;
        this.trim = true;
        if (!dimensioned) {
            arg[0] = parg.getX();
            arg[1] = parg.getY();
            arg[2] = arg[0] + arg[2];
            arg[3] = arg[1] + arg[3];
            arg[1] = Grappa.negateStringYCoord ? -arg[1] : arg[1];
            arg[3] = Grappa.negateStringYCoord ? -arg[3] : arg[3];
        } else {
            arg[0] = parg.getX();
            arg[1] = Grappa.negateStringYCoord ? -parg.getY() : parg.getY();
            arg[2] = parg.getWidth();
            arg[3] = parg.getHeight();
        }
        val[0] = arg[0];
        val[1] = arg[1];
        val[2] = arg[2];
        val[3] = arg[3];
        int orig_precision = this.precision;
        for (int i = 0; i < 4; ++i) {
            int n;
            this.precision = orig_precision;
            ival[i] = (int)val[i];
            val[i] = val[i] < 0.0 ? -val[i] : val[i];
            exp[i] = val[i] >= 1.0 ? Math.log(val[i]) / LOG10 : Math.log(val[i] / 10.0) / LOG10;
            iexp[i] = (int)exp[i];
            if (this.precision >= 0) {
                n = this.precision - 1;
                this.precision = this.precision;
            } else {
                n = this.precision = 5;
            }
            if (val[i] == ival[i]) {
                if (this.alternate) {
                    if (this.precision < 0 || iexp[i] <= this.precision) {
                        this.precision -= iexp[i];
                        retbuf = this.buildFloat(buf, arg[i]);
                    } else {
                        retbuf = this.buildExp(buf, arg[i], upper);
                    }
                } else if (this.precision < 0 || iexp[i] <= this.precision) {
                    this.precision = -1;
                    retbuf = this.buildInteger(buf, (long)arg[i]);
                } else {
                    retbuf = this.buildExp(buf, arg[i], upper);
                }
            } else {
                retbuf = iexp[i] < -4 || iexp[i] > this.precision ? this.buildExp(buf, arg[i], upper) : this.buildFloat(buf, arg[i]);
            }
            if (i >= 3) continue;
            buf = retbuf = retbuf.append(',');
        }
        return retbuf;
    }

    final StringBuilder buildFloat(StringBuilder buf, double arg) {
        this.precision = this.precision >= 0 ? this.precision : 6;
        double val = arg;
        if (this.padding == '0' && this.precision >= 0) {
            this.padding = (char)32;
        }
        return this.strpad(buf, this.doubleToString(val, ""), this.padding, this.width, this.rightpad);
    }

    final StringBuilder buildHex(StringBuilder buf, int arg, boolean upper) {
        String str;
        this.scratch.setLength(0);
        String string = str = upper ? Integer.toHexString(arg).toUpperCase() : Integer.toHexString(arg);
        if (this.precision > str.length()) {
            if (this.alternate) {
                this.scratch.append(upper ? "0X" : "0x");
            }
            this.strpad(this.scratch, str, 48, this.precision, false);
            this.strpad(buf, this.scratch.toString(), 32, this.width, this.rightpad);
        } else if (this.zeropad && !this.rightpad && this.precision < 0) {
            if (this.alternate) {
                if (this.width > 2) {
                    this.strpad(this.scratch, str, 48, this.width - 2, this.rightpad);
                    buf.append(upper ? "0X" : "0x");
                    buf.append(this.scratch.toString());
                } else {
                    buf.append(upper ? "0X" : "0x");
                    buf.append(str);
                }
            } else {
                this.strpad(buf, str, 48, this.width, this.rightpad);
            }
        } else {
            if (this.alternate) {
                this.scratch.append(upper ? "0X" : "0x");
                this.scratch.append(str);
                str = this.scratch.toString();
            }
            this.strpad(buf, str, 32, this.width, this.rightpad);
        }
        return buf;
    }

    final StringBuilder buildInteger(StringBuilder buf, long arg) {
        this.scratch.setLength(0);
        long val = arg;
        String sign = val >= 0L ? this.plus : "-";
        String str = "" + (val < 0L ? -val : val);
        if (this.precision > str.length()) {
            this.strpad(this.scratch, str, 48, this.precision, false);
            this.scratch.insert(0, sign);
        } else {
            this.scratch.append(sign);
            this.scratch.append(str);
        }
        if (this.padding == '0' && this.precision >= 0) {
            this.padding = (char)32;
        }
        return this.strpad(buf, this.scratch.toString(), this.padding, this.width, this.rightpad);
    }

    final StringBuilder buildOctal(StringBuilder buf, int arg) {
        this.scratch.setLength(0);
        if (this.alternate) {
            this.scratch.append('0');
        }
        this.scratch.append(Integer.toOctalString(arg));
        if (this.precision > this.scratch.length()) {
            String str = this.scratch.toString();
            this.scratch.setLength(0);
            this.strpad(this.scratch, str, 48, this.precision, false);
        }
        if (this.padding == '0' && this.precision >= 0) {
            this.padding = (char)32;
        }
        return this.strpad(buf, this.scratch.toString(), this.padding, this.width, this.rightpad);
    }

    final StringBuilder buildString(StringBuilder buf, String arg) {
        String str = this.precision > 0 ? (this.precision < arg.length() ? arg.substring(0, this.precision) : arg) : arg;
        return this.strpad(buf, str, this.padding, this.width, this.rightpad);
    }

    private String doubleToString(double val, String exp) {
        this.scratch.setLength(0);
        String sign = val >= 0.0 ? this.plus : "-";
        val = val < 0.0 ? -val : val;
        double whole = Math.floor(val);
        if (this.precision != 0) {
            double power = Math.pow(10.0, this.precision);
            double frac = (val - whole) * power;
            this.scratch.append((long)whole);
            String tail = "" + Math.round(frac);
            if (this.trim) {
                int extra;
                int len = tail.length();
                for (extra = 0; extra < len && tail.charAt(len - extra - 1) == '0'; ++extra) {
                }
                if (extra == len) {
                    tail = exp.length() > 0 ? ".0" : "";
                    this.precision = 0;
                } else if (extra > 0) {
                    this.scratch.append('.');
                    tail = tail.substring(0, len - extra);
                    this.precision -= extra;
                } else {
                    this.scratch.append('.');
                }
            } else {
                this.scratch.append('.');
            }
            if (this.precision > 0 && power / 10.0 > frac) {
                this.strpad(this.scratch, tail, 48, this.precision, false);
            } else {
                this.scratch.append(tail);
            }
            this.scratch.append(exp);
        } else {
            this.scratch.append((long)whole);
            if (this.alternate && exp.length() == 0) {
                this.scratch.append('.');
            }
            this.scratch.append(exp);
        }
        if (this.zeropad && !this.rightpad) {
            String str = this.scratch.toString();
            this.scratch.setLength(0);
            this.strpad(this.scratch, str, 48, this.width - sign.length(), false);
        }
        this.scratch.insert(0, sign);
        return this.scratch.toString();
    }

    private StringBuilder strpad(StringBuilder buf, String str, int ch, int width, boolean right) {
        if (width > 0) {
            int len = width - str.length();
            if (len > 0) {
                if (right) {
                    buf.append(str);
                }
                for (int n = 0; n < len; ++n) {
                    buf.append((char)ch);
                }
                if (!right) {
                    buf.append(str);
                }
            } else {
                buf.append(str);
            }
        } else {
            buf.append(str);
        }
        return buf;
    }
}

