/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Attribute;
import att.grappa.Element;
import att.grappa.GraphIterator;
import att.grappa.Grappa;
import att.grappa.GrappaPanel;
import att.grappa.Subgraph;
import java.awt.font.FontRenderContext;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph
extends Subgraph {
    public static final String INDENT_STRING = "  ";
    public boolean filterMode = false;
    private StringBuilder indent = null;
    private PrintWriter errWriter = null;
    private boolean paintCalled = false;
    private boolean busy = false;
    private boolean synchronizePaint = false;
    private String toolTipText = null;
    private List<GrappaPanel> panelList = null;
    private int gid = 0;
    private int nid = 0;
    private int eid = 0;
    private boolean editable = false;
    private boolean menuable = false;
    private boolean selectable = true;
    private boolean directed = true;
    private boolean strict = false;
    HashMap<Long, Element> id2element = null;
    private HashMap<String, Attribute> grattributes = null;
    private static HashMap<String, Attribute> sysdfltNodeAttributes = new HashMap(11);
    private static HashMap<String, Attribute> sysdfltEdgeAttributes = new HashMap(9);
    private static HashMap<String, Attribute> sysdfltGraphAttributes = new HashMap(13);
    public final FontRenderContext REFCNTXT = new FontRenderContext(IDENTXFRM, Grappa.useAntiAliasing, Grappa.useFractionalMetrics);

    private static void putAttribute(HashMap<String, Attribute> table, int type, String name, String value) {
        Attribute attr = new Attribute(type, name, value);
        attr.clearChanged();
        table.put(name, attr);
    }

    public Graph(String graphName, boolean directed, boolean strict) {
        this.initialize(graphName);
        this.setDirection(directed);
        this.strict = strict;
        this.setGrappaAttribute("grappaBackgroundColor", "white");
        this.setGrappaAttribute("grappaSelectionColor", "lineColor(red),lineWidth(3)");
        this.setGrappaAttribute("grappaDeletionColor", "lineColor(grey85),lineWidth(3),dotted");
        this.setGrappaAttribute("grappaFontsizeAdjustment", "0");
    }

    public Graph(String graphName) {
        this(graphName, true, false);
    }

    private void initialize(String graphName) {
        this.gid = 0;
        this.nid = 0;
        this.eid = 0;
        this.clearBBox();
        if (this.id2element != null) {
            this.id2element.clear();
        }
        this.setGraph(this);
        this.setSubgraph(null);
        this.setIdKey(4);
        this.addIdMapping(this);
        this.setName(graphName);
        Iterator<Attribute> enm = Graph.getGlobalAttributePairs(1);
        while (enm.hasNext()) {
            this.setNodeAttribute(enm.next());
        }
        enm = Graph.getGlobalAttributePairs(2);
        while (enm.hasNext()) {
            this.setEdgeAttribute(enm.next());
        }
        enm = Graph.getGlobalAttributePairs(4);
        while (enm.hasNext()) {
            this.setAttribute(enm.next());
        }
        this.setDelete(false);
    }

    private void setDirection(boolean directed) {
        this.directed = directed;
        if (directed) {
            this.setEdgeAttribute("dir", "forward");
        } else {
            this.setEdgeAttribute("dir", "none");
        }
    }

    public boolean setSynchronizePaint(boolean sync) {
        boolean oldSync = this.synchronizePaint;
        this.synchronizePaint = sync;
        return oldSync;
    }

    public boolean getSynchronizePaint() {
        return this.synchronizePaint;
    }

    public boolean dropcloth(boolean block, boolean auto) {
        return this.setBlocked(block, false, auto);
    }

    boolean setPaint(boolean paint) {
        return this.setBlocked(paint, true, false);
    }

    private synchronized boolean setBlocked(boolean state, boolean isPaint, boolean repaint) {
        if (isPaint) {
            if (state) {
                this.paintCalled = true;
                if (this.busy) {
                    return false;
                }
                this.busy = true;
                return true;
            }
            this.busy = false;
            this.paintCalled = false;
            return true;
        }
        if (state) {
            if (this.paintCalled) {
                return false;
            }
            this.busy = true;
            return true;
        }
        if (!this.paintCalled) {
            this.busy = false;
        } else {
            this.paintCalled = false;
            this.busy = false;
            if (repaint) {
                this.repaint();
            }
        }
        return true;
    }

    public Attribute getGrappaAttribute(String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key value cannot be null");
        }
        if (this.grattributes == null) {
            return null;
        }
        return this.grattributes.get(key);
    }

    public Object getGrappaAttributeValue(String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key value cannot be null");
        }
        if (this.grattributes == null) {
            return null;
        }
        Attribute attr = this.grattributes.get(key);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public Object setGrappaAttribute(String key, String value) throws IllegalArgumentException {
        Attribute oldValue;
        if (this.grattributes == null) {
            this.grattributes = new HashMap(4);
        }
        if ((oldValue = this.getGrappaAttribute(key)) == null) {
            if (!Graph.validGrappaAttributeKey(key)) {
                throw new IllegalArgumentException("Grappa attribute key must use \"grappa\" as a prefix");
            }
            oldValue = new Attribute(8, key, value);
            this.grattributes.put(key, oldValue);
            return null;
        }
        this.grattributes.put(key, new Attribute(8, key, value));
        return oldValue.getValue();
    }

    public static int attributeType(String attrname) {
        int convtype = -1;
        if (attrname != null) {
            int hashCode = attrname.hashCode();
            convtype = hashCode == GRAPPA_BACKGROUND_COLOR_HASH && attrname.equals("grappaBackgroundColor") ? 2 : (hashCode == GRAPPA_SELECTION_STYLE_HASH && attrname.equals("grappaSelectionColor") ? 13 : (hashCode == GRAPPA_DELETION_STYLE_HASH && attrname.equals("grappaDeletionColor") ? 13 : (hashCode == GRAPPA_FONTSIZE_ADJUSTMENT_HASH && attrname.equals("grappaFontsizeAdjustment") ? 7 : 12)));
        }
        return convtype;
    }

    public Iterator<String> getGrappaAttributeKeys() {
        if (this.grattributes == null) {
            return Grappa.emptyStringIterator.iterator();
        }
        return this.grattributes.keySet().iterator();
    }

    public static boolean validGrappaAttributeKey(String key) {
        return key != null && key.startsWith("grappa") && key.length() > "grappa".length();
    }

    public static Attribute getGlobalAttribute(int type, String key) throws IllegalArgumentException {
        switch (type) {
            case 1: {
                return sysdfltNodeAttributes.get(key);
            }
            case 2: {
                return sysdfltEdgeAttributes.get(key);
            }
            case 4: {
                return sysdfltGraphAttributes.get(key);
            }
        }
        throw new IllegalArgumentException("specified type must be NODE, EDGE or SUBGRAPH");
    }

    public static Iterator<String> getGlobalAttributeKeys(int type) throws IllegalArgumentException {
        switch (type) {
            case 1: {
                return sysdfltNodeAttributes.keySet().iterator();
            }
            case 2: {
                return sysdfltEdgeAttributes.keySet().iterator();
            }
            case 4: {
                return sysdfltGraphAttributes.keySet().iterator();
            }
        }
        throw new IllegalArgumentException("specified type must be NODE, EDGE or SUBGRAPH");
    }

    public static Iterator<Attribute> getGlobalAttributePairs(int type) throws IllegalArgumentException {
        switch (type) {
            case 1: {
                return sysdfltNodeAttributes.values().iterator();
            }
            case 2: {
                return sysdfltEdgeAttributes.values().iterator();
            }
            case 4: {
                return sysdfltGraphAttributes.values().iterator();
            }
        }
        throw new IllegalArgumentException("specified type must be NODE, EDGE or SUBGRAPH");
    }

    public static int getGlobalAttributeSize(int type) throws IllegalArgumentException {
        switch (type) {
            case 1: {
                return sysdfltNodeAttributes.size();
            }
            case 2: {
                return sysdfltEdgeAttributes.size();
            }
            case 4: {
                return sysdfltGraphAttributes.size();
            }
        }
        throw new IllegalArgumentException("specified type must be NODE, EDGE or SUBGRAPH");
    }

    Element addIdMapping(Element elem) {
        if (elem == null) {
            return null;
        }
        if (this.id2element == null) {
            this.id2element = new HashMap();
        }
        return this.id2element.put(elem.getIdKey(), elem);
    }

    static Long idMapKey(int type, int id) throws IllegalArgumentException {
        long value = id;
        int tval = type & 7;
        if (tval == 0) {
            throw new IllegalArgumentException("supplied type does not specify node, edge or subgraph");
        }
        value = value << 3 | (long)(type & 7);
        return new Long(value);
    }

    static int idKeyType(Long idKey) {
        long value = idKey;
        return (int)(value & 7L);
    }

    static int idKeyId(Long idKey) {
        long value = idKey;
        return (int)(value >>> 3);
    }

    Element element4Id(Long idKey) {
        if (this.id2element == null) {
            return null;
        }
        return this.id2element.get(idKey);
    }

    void removeIdMapping(Element elem) {
        if (this.id2element != null && elem != null) {
            this.id2element.remove(elem.getIdKey());
        }
    }

    public void printGraph(Writer output) {
        PrintWriter out = null;
        out = output instanceof PrintWriter ? (PrintWriter)output : new PrintWriter(output);
        this.getGraph().printSubgraph(out);
        out.flush();
    }

    public void printGraph(OutputStream output) {
        this.printGraph(new PrintWriter(output));
    }

    int nextId(int type) throws IllegalArgumentException {
        switch (type) {
            case 1: {
                return this.nid++;
            }
            case 2: {
                return this.eid++;
            }
            case 4: {
                return this.gid++;
            }
        }
        throw new IllegalArgumentException("Type (" + type + ") is not recognized.");
    }

    public int getId(int type) throws IllegalArgumentException {
        switch (type) {
            case 1: {
                return this.nid;
            }
            case 2: {
                return this.eid;
            }
            case 4: {
                return this.gid;
            }
        }
        throw new IllegalArgumentException("Type (" + type + ") is not recognized.");
    }

    public String getIndent() {
        if (this.indent == null) {
            this.indent = new StringBuilder(5 * INDENT_STRING.length());
        }
        return this.indent.toString();
    }

    public void incrementIndent() {
        if (this.indent == null) {
            this.indent = new StringBuilder(5 * INDENT_STRING.length());
        }
        this.indent.append(INDENT_STRING);
    }

    public void decrementIndent() {
        int len = this.indent.length();
        if (len == 0) {
            return;
        }
        if (len < INDENT_STRING.length()) {
            this.indent.setLength(0);
        } else {
            this.indent.setLength(len - INDENT_STRING.length());
        }
    }

    public boolean isDirected() {
        return this.directed;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public String setToolTipText(String text) {
        String oldTip = this.toolTipText;
        this.toolTipText = text;
        return oldTip;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void reset() {
        String graphName = this.getName();
        if (this.delete()) {
            this.initialize(graphName);
        }
    }

    public void reset(String graphName, boolean directed, boolean strict) {
        this.name = graphName;
        this.reset();
        this.setDirection(directed);
        this.strict = strict;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean setEditable(boolean mode) {
        boolean wasMode = this.editable;
        this.editable = mode;
        return wasMode;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean setSelectable(boolean mode) {
        boolean wasMode = this.selectable;
        this.selectable = mode;
        return wasMode;
    }

    public boolean isMenuable() {
        return this.menuable;
    }

    public boolean setMenuable(boolean mode) {
        boolean wasMode = this.menuable;
        this.menuable = mode;
        return wasMode;
    }

    public PrintWriter setErrorWriter(PrintWriter errWriter) {
        PrintWriter oldWriter = this.errWriter;
        this.errWriter = errWriter;
        return oldWriter;
    }

    public PrintWriter getErrorWriter() {
        return this.errWriter;
    }

    public void printError(String msg) {
        this.printError(msg, null);
    }

    public void printError(String msg, Exception ex) {
        if (this.getErrorWriter() == null) {
            return;
        }
        this.getErrorWriter().println("ERROR: " + msg);
        if (ex != null) {
            ex.printStackTrace(this.getErrorWriter());
        }
        this.getErrorWriter().flush();
    }

    public void buildShapes() {
        GraphIterator enm = this.elements();
        while (enm.hasNext()) {
            Element elem = enm.nextGraphElement();
            if (elem.grappaNexus != null) continue;
            elem.buildShape();
        }
    }

    public void resync() {
        Element elem = null;
        GraphIterator enm = this.elements();
        while (enm.hasNext()) {
            elem = enm.nextGraphElement();
            if (elem.grappaNexus == null) {
                elem.buildShape();
                continue;
            }
            elem.grappaNexus.rebuild();
        }
    }

    public void repaint() {
        if (this.panelList == null) {
            return;
        }
        boolean incomplete = true;
        ListIterator<GrappaPanel> li = null;
        while (incomplete) {
            try {
                li = this.panelList.listIterator(0);
                while (li.hasNext()) {
                    li.next().repaint();
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            incomplete = false;
        }
    }

    public void paintImmediately() {
        if (this.panelList == null) {
            return;
        }
        boolean incomplete = true;
        ListIterator<GrappaPanel> li = null;
        GrappaPanel panel = null;
        while (incomplete) {
            try {
                li = this.panelList.listIterator(0);
                while (li.hasNext()) {
                    panel = li.next();
                    panel.paintImmediately(panel.getVisibleRect());
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            incomplete = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPanel(GrappaPanel panel) {
        if (this.panelList == null) {
            this.panelList = Collections.synchronizedList(new LinkedList());
        }
        List<GrappaPanel> list = this.panelList;
        synchronized (list) {
            if (!this.panelList.contains(panel)) {
                this.panelList.add(panel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePanel(GrappaPanel panel) {
        if (this.panelList == null) {
            return;
        }
        List<GrappaPanel> list = this.panelList;
        synchronized (list) {
            this.panelList.remove(panel);
        }
    }

    static {
        Graph.putAttribute(sysdfltNodeAttributes, 1, "color", "black");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "fontcolor", "black");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "fontname", "TimesRoman");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "fontsize", "14");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "fontstyle", "normal");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "height", "0.5");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "pos", "0,0");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "label", "\\N");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "shape", "ellipse");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "style", "__default__");
        Graph.putAttribute(sysdfltNodeAttributes, 1, "width", "0.75");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "color", "black");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "dir", "forward");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "fontcolor", "black");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "fontname", "TimesRoman");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "fontsize", "14");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "fontstyle", "normal");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "minlen", "1");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "style", "__default__");
        Graph.putAttribute(sysdfltEdgeAttributes, 2, "weight", "1");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "clusterrank", "local");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "color", "white");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "fontcolor", "black");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "fontname", "TimesRoman");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "fontsize", "14");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "fontstyle", "normal");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "margin", "0.5,0.5");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "mclimit", "1");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "nodesep", "0.25");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "orientation", "portrait");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "rankdir", "TB");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "ranksep", "0.75");
        Graph.putAttribute(sysdfltGraphAttributes, 4, "style", "__default__");
    }
}

