/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import att.grappa.CustomRenderer;
import att.grappa.Element;
import att.grappa.Graph;
import att.grappa.Node;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.CompoundTermImpl;
import com.parctechnologies.eclipse.visualisation.BatchGoal;
import com.parctechnologies.eclipse.visualisation.ElementType;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewletAction;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletDataImpl;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.ViewletType;
import com.parctechnologies.eclipse.visualisation.ViewletTypeRangeCommand;
import com.parctechnologies.eclipse.visualisation.viewers.AbstractViewletType;
import com.parctechnologies.eclipse.visualisation.viewers.CustRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class BoundsViewletType
extends AbstractViewletType {
    private TableCellRenderer tableCellRenderer;
    private CustomRenderer customRenderer;

    public BoundsViewletType(String string) {
        super(string);
    }

    @Override
    public boolean canBuildFrom(ElementType elementType) {
        return true;
    }

    @Override
    public ViewletData build() {
        return new Data();
    }

    @Override
    public String getDescription() {
        return "Bounds viewlet";
    }

    @Override
    public synchronized TableCellRenderer getTableCellRenderer() {
        if (this.tableCellRenderer == null) {
            this.tableCellRenderer = new CellRenderer();
        }
        return this.tableCellRenderer;
    }

    @Override
    public Class getCustomRendererClass() {
        return Renderer.class;
    }

    @Override
    public void customizeElement(ViewletDataStore viewletDataStore, List list, Element element) {
        Data data = (Data)viewletDataStore.getViewletDataAt(list);
        if (element instanceof Node) {
            element.setAttribute("shape", (Object)new Integer(28));
            element.setAttribute("custom", (Object)this.getCustomRendererClass().getName());
            element.setAttribute("label", (Object)"");
            if (data.getHoldsOnUpdates()) {
                element.setAttribute("color", (Object)Color.blue.darker());
            } else {
                element.setAttribute("color", (Object)Color.blue);
            }
            element.setAttribute("style", (Object)"filled");
            element.object = data;
            element.getGrappaNexus().updateShape();
        }
    }

    @Override
    public BatchGoal collectPreBuildGoal(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        BatchGoal batchGoal = new BatchGoal();
        for (List list : viewletRange) {
            CompoundTermImpl compoundTermImpl = new CompoundTermImpl("get_var_bounds", (Object)new CompoundTermImpl("element", (Object)list), null, null);
            batchGoal.add(this.composeElementGoal(list, (CompoundTerm)viewletDataStore.getViewable().getNameAtom(), (CompoundTerm)compoundTermImpl));
        }
        return batchGoal;
    }

    protected void processResults(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, List list, boolean bl) {
        Iterator iterator = viewletRange.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            Data data = (Data)viewletDataStore.getViewletDataAt(list2);
            CompoundTermImpl compoundTermImpl = (CompoundTermImpl)iterator2.next();
            Double d = (Double)this.decomposeElementGoal((CompoundTerm)compoundTermImpl).arg(2);
            Double d2 = (Double)this.decomposeElementGoal((CompoundTerm)compoundTermImpl).arg(3);
            if (data == null) {
                data = (Data)this.build();
            }
            if (bl) {
                data.setAbsoluteBounds(d, d2);
                data.setInitialBounds(d, d2);
            }
            data.setCurrentBounds(d, d2);
            viewletDataStore.setViewletDataAt(list2, data);
        }
    }

    @Override
    public void startBuild(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, List list) {
        this.processResults(viewer, viewletDataStore, viewletRange, list, true);
    }

    @Override
    public BatchGoal collectPreUpdateGoal(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, UpdateEvent updateEvent) {
        BatchGoal batchGoal = new BatchGoal();
        for (List list : viewletRange) {
            CompoundTermImpl compoundTermImpl = new CompoundTermImpl("get_var_bounds", (Object)new CompoundTermImpl("element", (Object)list), null, null);
            batchGoal.add(this.composeElementGoal(list, (CompoundTerm)viewletDataStore.getViewable().getNameAtom(), (CompoundTerm)compoundTermImpl));
        }
        return batchGoal;
    }

    protected void setUpdating(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, int n) {
        for (List list : viewletRange) {
            Data data = (Data)viewletDataStore.getViewletDataAt(list);
            if (data == null) {
                data = (Data)this.build();
            }
            viewletDataStore.setViewletDataAt(list, data);
        }
    }

    @Override
    public void startUpdate(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, List list, UpdateEvent updateEvent) {
        this.processResults(viewer, viewletDataStore, viewletRange, list, false);
        viewletDataStore.fireViewletRangeUpdated(viewletRange);
    }

    public double getMin(ViewletDataStore viewletDataStore, List list) {
        return ((Data)viewletDataStore.getViewletDataAt((List)list)).absoluteMin;
    }

    public double getMax(ViewletDataStore viewletDataStore, List list) {
        return ((Data)viewletDataStore.getViewletDataAt((List)list)).absoluteMax;
    }

    @Override
    public Collection getActions(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        Collection collection = super.getActions(viewletDataStore, viewletRange);
        if (viewletRange != null & !viewletRange.isEmpty()) {
            collection.add(new AlignBoundsAction(viewletDataStore, viewletRange));
            collection.add(new ToggleHorizontalVerticalAction(viewletDataStore, viewletRange));
        }
        if (viewletRange != null & viewletRange.size() == 1) {
            List list = (List)viewletRange.iterator().next();
            collection.add(new DisplayBoundsInDetailAction(viewletDataStore, list));
        }
        return collection;
    }

    protected void allignBounds(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        Data data;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (List list : viewletRange) {
            data = (Data)viewletDataStore.getViewletDataAt(list);
            if (data.initialMin < d) {
                d = data.initialMin;
            }
            if (!(data.initialMax > d2)) continue;
            d2 = data.initialMax;
        }
        for (List list : viewletRange) {
            data = (Data)viewletDataStore.getViewletDataAt(list);
            data.setAbsoluteBounds(d, d2);
            viewletDataStore.setViewletDataAt(list, data);
        }
        viewletDataStore.fireViewletRangeUpdated(viewletRange);
    }

    protected void toggleHorizontalVertical(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        Data data;
        boolean bl = true;
        for (List list : viewletRange) {
            data = (Data)viewletDataStore.getViewletDataAt(list);
            if (!data.vertical) continue;
            bl = false;
        }
        for (List list : viewletRange) {
            data = (Data)viewletDataStore.getViewletDataAt(list);
            data.vertical = bl;
            viewletDataStore.setViewletDataAt(list, data);
        }
        viewletDataStore.fireViewletRangeUpdated(viewletRange);
    }

    public static class Renderer
    extends CustRenderer {
        public Renderer(Element element, double d, double d2, double d3, double d4) {
            super(element, d, d2, d3, d4);
            Data data = (Data)this.getViewletData();
            if (data != null) {
                this.configure(new Rectangle2D.Double(d, d2, d3, d4), data.absoluteMin, data.absoluteMax, data.initialMin, data.initialMax, data.min, data.max, data.vertical);
            }
        }

        public void configure(Rectangle2D rectangle2D, double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
            float[][] fArrayArray;
            float f;
            float f2;
            float f3;
            float f4;
            if (bl) {
                f4 = (float)rectangle2D.getMinY();
                f3 = (float)rectangle2D.getMaxY();
            } else {
                f4 = (float)rectangle2D.getMinX();
                f3 = (float)rectangle2D.getMaxX();
            }
            if (d2 == d) {
                d2 += 1.0;
            }
            float f5 = (f3 - f4) / (float)(d2 - d);
            float f6 = f4 + (float)d3 * f5;
            float f7 = f4 + (float)d5 * f5;
            float f8 = f4 + (float)d6 * f5;
            float f9 = f4 + (float)d4 * f5;
            if (bl) {
                f2 = (float)rectangle2D.getMinX();
                f = (float)rectangle2D.getMaxX();
            } else {
                f2 = (float)rectangle2D.getMinY();
                f = (float)rectangle2D.getMaxY();
            }
            float f10 = (f - f2) / 16.0f;
            float f11 = f2 + 8.0f * f10;
            float f12 = f11 - 4.0f * f10;
            float f13 = f11 - 1.0f * f10;
            float f14 = f11 + 1.0f * f10;
            float f15 = f11 + 4.0f * f10;
            float[][] fArrayArray2 = bl ? (fArrayArray = new float[][]{{f12, f6}, {f13, f6}, {f13, f7}, {f2, f7}, {f2, f8}, {f13, f8}, {f13, f9}, {f12, f9}, {f15, f9}, {f14, f9}, {f14, f8}, {f, f8}, {f, f7}, {f14, f7}, {f14, f6}, {f15, f6}}) : (fArrayArray = new float[][]{{f6, f12}, {f6, f13}, {f7, f13}, {f7, f2}, {f8, f2}, {f8, f13}, {f9, f13}, {f9, f12}, {f9, f15}, {f9, f14}, {f8, f14}, {f8, f}, {f7, f}, {f7, f14}, {f6, f14}, {f6, f15}});
            this.path.moveTo(fArrayArray2[0][0], fArrayArray2[0][1]);
            for (int i = 1; i < fArrayArray2.length; ++i) {
                this.path.lineTo(fArrayArray2[i][0], fArrayArray2[i][1]);
            }
            this.path.closePath();
        }
    }

    public static class RendererIcon
    implements Icon {
        Renderer renderer;
        Data data;
        Rectangle bounds;

        public RendererIcon(Renderer renderer, Data data, Rectangle rectangle) {
            this.renderer = renderer;
            this.data = data;
            int n = rectangle.width * 9 / 10;
            int n2 = rectangle.height * 9 / 10;
            int n3 = rectangle.width * 1 / 20;
            int n4 = rectangle.height * 1 / 20;
            this.bounds = new Rectangle(n3, n4, n, n2);
        }

        @Override
        public int getIconHeight() {
            return this.bounds.height;
        }

        @Override
        public int getIconWidth() {
            return this.bounds.width;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.renderer.configure(this.bounds, this.data.absoluteMin, this.data.absoluteMax, this.data.initialMin, this.data.initialMax, this.data.min, this.data.max, this.data.vertical);
            graphics.setColor(Color.black);
            this.renderer.draw((Graphics2D)graphics);
            graphics.setColor(Color.blue);
            this.renderer.fill((Graphics2D)graphics);
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        public CellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Rectangle rectangle;
            JLabel jLabel;
            if (jTable == null) {
                jLabel = new JLabel();
                rectangle = jLabel.getBounds();
            } else {
                jLabel = (JLabel)super.getTableCellRendererComponent(jTable, "", bl, bl2, n, n2);
                rectangle = jTable.getCellRect(n, n2, false);
            }
            Data data = (Data)object;
            Graphics2D graphics2D = (Graphics2D)jLabel.getGraphics();
            Graph graph = new Graph("bar");
            graph.object = null;
            Renderer renderer = new Renderer((Element)graph, 0.0, 0.0, 1.0, 1.0);
            if (data.getHoldsOnUpdates()) {
                if (bl) {
                    jLabel.setBackground(Color.white.darker().darker().darker());
                } else {
                    jLabel.setBackground(Color.white.darker());
                }
            } else if (bl) {
                jLabel.setBackground(Color.white.darker().darker());
            } else {
                jLabel.setBackground(Color.white);
            }
            jLabel.setIcon(new RendererIcon(renderer, data, rectangle));
            return jLabel;
        }

        @Override
        public void setValue(Object object) {
            super.setValue(object);
            this.setToolTipText(object.toString());
        }
    }

    protected class DisplayBoundsInDetailAction
    extends ViewletAction {
        List index;
        ViewletDataStore store;

        DisplayBoundsInDetailAction(ViewletDataStore viewletDataStore, List list) {
            super("Display bounds");
            this.putValue("Name", "Display bounds");
            this.putValue("LongDescription", "Popup window displaying bounds in detail");
            this.putValue("ShortDescription", "Popup window displaying bounds in detail");
            this.store = viewletDataStore;
            this.index = list;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Data data = (Data)this.store.getViewletDataAt(this.index);
            JOptionPane.showConfirmDialog(null, "Initial upper bound: " + data.initialMax + "\n\nCurrent upper bound: " + data.max + "\n\nCurrent lower bound: " + data.min + "\n\nInitial lower bound: " + data.initialMin, "Bounds data in detail", -1);
        }
    }

    protected class ToggleHorizontalVerticalAction
    extends ViewletAction {
        ViewletRange range;
        ViewletDataStore store;

        ToggleHorizontalVerticalAction(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
            super("Toggle horizontal/vertical range bar");
            this.putValue("Name", "Toggle horizontal/vertical range bar");
            this.putValue("LongDescription", "Change whether the range bar is displayed horizontally or vertically");
            this.putValue("ShortDescription", "Change whether the range bar is horizontal or vertical");
            this.store = viewletDataStore;
            this.range = viewletRange;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ToggleHorizontalVerticalCommand(BoundsViewletType.this, this.store, this.range).issue();
        }
    }

    public static class ToggleHorizontalVerticalCommand
    extends ViewletTypeRangeCommand {
        public ToggleHorizontalVerticalCommand(ViewletType viewletType, ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
            super(viewletType, viewletDataStore, viewletRange);
        }

        @Override
        public void postRecordIssue() {
            ((BoundsViewletType)this.getViewletType()).toggleHorizontalVertical(this.getViewletDataStore(), this.getViewletRange());
        }
    }

    protected class AlignBoundsAction
    extends ViewletAction {
        ViewletRange range;
        ViewletDataStore store;

        AlignBoundsAction(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
            super("Align bounds");
            this.putValue("Name", "Align bounds");
            this.putValue("LongDescription", "Re-align a selection of bounds viewlets so that their bounds are displayed on the same axes");
            this.putValue("ShortDescription", "Re-align so that bounds viewlets use the same axes");
            this.store = viewletDataStore;
            this.range = viewletRange;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new AlignBoundsCommand(BoundsViewletType.this, this.store, this.range).issue();
        }
    }

    public static class AlignBoundsCommand
    extends ViewletTypeRangeCommand {
        public AlignBoundsCommand(ViewletType viewletType, ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
            super(viewletType, viewletDataStore, viewletRange);
        }

        @Override
        public void postRecordIssue() {
            ((BoundsViewletType)this.getViewletType()).allignBounds(this.getViewletDataStore(), this.getViewletRange());
        }
    }

    public static class Data
    extends ViewletDataImpl {
        double absoluteMin;
        double absoluteMax;
        double initialMin;
        double initialMax;
        double min;
        double max;
        boolean vertical;

        public String toString() {
            return this.initialMin + ".." + this.min + ".." + this.max + ".." + this.initialMax;
        }

        public void setAbsoluteBounds(double d, double d2) {
            this.absoluteMin = d;
            this.absoluteMax = d2;
        }

        public void setInitialBounds(double d, double d2) {
            this.initialMin = d;
            this.initialMax = d2;
        }

        public void setCurrentBounds(double d, double d2) {
            this.min = d;
            this.max = d2;
        }
    }
}

