/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.CompoundTermImpl;
import com.parctechnologies.eclipse.EXDRInputStream;
import com.parctechnologies.eclipse.EXDROutputStream;
import com.parctechnologies.eclipse.EclipseConnection;
import com.parctechnologies.eclipse.EclipseException;
import com.parctechnologies.eclipse.EclipseMultitaskConnection;
import com.parctechnologies.eclipse.EclipseTerminatedException;
import com.parctechnologies.eclipse.Fail;
import com.parctechnologies.eclipse.FromEclipseQueue;
import com.parctechnologies.eclipse.MultitaskListener;
import com.parctechnologies.eclipse.QueueListener;
import com.parctechnologies.eclipse.ToEclipseQueue;
import com.parctechnologies.eclipse.visualisation.BatchGoal;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.InterestSpec;
import com.parctechnologies.eclipse.visualisation.ScenarioManager;
import com.parctechnologies.eclipse.visualisation.SizeEvent;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.ViewerManager;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import com.parctechnologies.eclipse.visualisation.VisException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;

public class VisClient {
    protected VisClientStateModel stateModel;
    private FromEclipseQueue viewables_stream;
    private String viewables_stream_name;
    private FromEclipseQueue updates_stream;
    private String updates_stream_name;
    private ToEclipseQueue interest_stream;
    private String interest_stream_name;
    private EXDROutputStream interest_stream_f;
    protected Atom clientName;
    protected static final String MULTITASK_PHASE_TYPE = "vis_event";
    private static final Atom terminateAtom = new Atom("terminate");
    private static final Atom visProtocolSupportedAtom = new Atom("vis_protocol_supported");
    private static final Atom vcSupportAtom = new Atom("vc_support");
    private static final Atom viewGranularityAtom = new Atom("view_granularity");
    private VisClient visClient;
    private ViewerManager viewerManager;
    private static final int SUPPORTED_PROTOCOL_VERSION = 1;
    private boolean protocol_version_supported;
    private EclipseMultitaskConnection eclipse;
    private VisEvent currentEvent;

    public VisClient(EclipseMultitaskConnection eclipseMultitaskConnection) {
        this.eclipse = eclipseMultitaskConnection;
        try {
            this.initialise();
        }
        catch (EclipseException eclipseException) {
            this.recover_ee(eclipseException);
        }
        catch (IOException iOException) {
            this.recover_ioe(iOException);
        }
        catch (VisException visException) {
            this.recover_ve(visException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(VisEvent visEvent) {
        this.currentEvent = visEvent;
        this.stateModel.setEclipseHasControl(false);
        String string = visEvent.getViewableName();
        this.stateModel.setCurrentState(1);
        if (visEvent instanceof CreateEvent) {
            ScenarioManager.getInstance().selectPlaybackScenario(string);
            this.stateModel.setViewerBuildingPolicySelected(false);
        }
        ScenarioManager.getInstance().processEvent(visEvent);
        if (visEvent instanceof CreateEvent) {
            this.viewerManager.configureViewerBuildingPolicy(string, ((CreateEvent)visEvent).getViewableType());
        }
        this.stateModel.setCurrentState(2);
        ScenarioManager.getInstance().processEvent(visEvent);
        this.viewerManager.prepareForEvent(visEvent);
        BatchGoal batchGoal = this.viewerManager.collectPreEventGoals(visEvent);
        List list = null;
        try {
            this.stateModel.setCurrentState(3);
            ScenarioManager.getInstance().processEvent(visEvent);
            this.stateModel.setEclipseHasControl(true);
            list = batchGoal.execute((EclipseConnection)this.eclipse);
            this.stateModel.setEclipseHasControl(false);
        }
        catch (EclipseException eclipseException) {
            this.recover_ee(eclipseException);
        }
        catch (IOException iOException) {
            this.recover_ioe(iOException);
        }
        this.stateModel.setCurrentState(4);
        this.viewerManager.startEvent(visEvent, list);
        this.stateModel.setAllScenarioCommandsExecuted(false);
        ScenarioManager.getInstance().processEvent(visEvent);
        if ((this.viewerManager.shouldHold() || this.stateModel.getInterrupt()) && !this.stateModel.getTerminate()) {
            try {
                SwingUtilities.invokeAndWait(new AllCommandsExecuted());
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.stateModel.setCurrentState(5);
            try {
                this.eclipse.rpc(":", (Object)vcSupportAtom, (Object)new Atom("vis_client_breakpoint"));
            }
            catch (IOException iOException) {
                this.recover_ioe(iOException);
            }
            catch (EclipseException eclipseException) {
                this.recover_ee(eclipseException);
            }
            finally {
                this.viewerManager.holdingEvent(visEvent);
            }
            this.stateModel.setCurrentState(6);
            ScenarioManager.getInstance().processEvent(visEvent);
        } else {
            this.stopEvent();
        }
        VisClientStateModel visClientStateModel = this.stateModel;
        synchronized (visClientStateModel) {
            if (this.stateModel.getTerminate()) {
                this.terminate();
            }
            this.stateModel.setEclipseHasControl(true);
        }
    }

    private void stopEvent() {
        Collection collection = null;
        VisEvent visEvent = this.currentEvent;
        String string = visEvent.getViewableName();
        this.stateModel.setCurrentState(7);
        ScenarioManager.getInstance().processEvent(visEvent);
        this.viewerManager.stopEvent();
        if (visEvent instanceof CreateEvent) {
            collection = this.viewerManager.getInterestSpecs(string);
            try {
                this.expressInterestsToEclipse(string, collection);
            }
            catch (IOException iOException) {
                this.recover_ioe(iOException);
            }
            this.addInterestSynchronisers(collection);
        }
        this.stateModel.setCurrentState(0);
        ScenarioManager.getInstance().processEvent(visEvent);
        this.currentEvent = null;
    }

    private void addInterestSynchronisers(Collection collection) {
        for (InterestSpec interestSpec : collection) {
            interestSpec.getPropertyChangeSupport().addPropertyChangeListener("viewGranularity", new InterestSpecSynchroniser(interestSpec));
        }
    }

    private void expressInterestsToEclipse(String string, Collection collection) throws IOException {
        Atom atom = collection.isEmpty() ? new Atom("no") : new Atom("yes");
        this.interest_stream_f.write((Object)new CompoundTermImpl("interest", (Object)new CompoundTermImpl("viewable_create", (Object)new Atom(string)), (Object)atom, (Object)collection));
        this.interest_stream_f.flush();
    }

    private void initialise() throws IOException, EclipseException, VisException {
        this.initialiseStreams();
        this.initialiseQueueListeners();
        this.registerVC();
        this.initialiseStateModel();
        this.initialiseViewerManager();
        this.initialiseScenarioManager();
    }

    private void initialiseStateModel() throws EclipseException, IOException {
        this.stateModel = new VisClientStateModel(this.eclipse, this.clientName, this);
        this.stateModel.setEclipseLibDir(String.valueOf(this.eclipse.rpc("get_flag(installation_directory, _)").arg(2)) + File.separator + "lib" + File.separator + String.valueOf(this.eclipse.rpc("get_flag(hostarch,_)").arg(2)));
    }

    private void initialiseViewerManager() {
        this.viewerManager = new ViewerManager(this.stateModel);
    }

    private void initialiseScenarioManager() {
        ScenarioManager.initialise(this.stateModel);
    }

    private void initialiseQueueListeners() throws IOException {
        this.viewables_stream.setListener((QueueListener)new ViewablesQL());
        this.updates_stream.setListener((QueueListener)new UpdatesQL());
    }

    private void registerVC() throws IOException, EclipseException, VisException {
        int n = 0;
        this.clientName = null;
        this.eclipse.rpc("ensure_loaded(library(vc_support))");
        this.protocol_version_supported = false;
        while (this.clientName == null) {
            this.interest_stream_f.write((Object)new CompoundTermImpl("vis_protocol_version", (Object)new Integer(1)));
            this.interest_stream_f.flush();
            try {
                this.eclipse.rpc(":", (Object)vcSupportAtom, (Object)new CompoundTermImpl("vis_client_register", (Object)new Atom(this.eclipse.getPeerName().functor() + "_jvc_" + n), (Object)new Atom(this.viewables_stream_name), (Object)new Atom(this.updates_stream_name), (Object)new Atom(this.interest_stream_name)));
            }
            catch (Fail fail) {
                if (!this.protocol_version_supported) {
                    throw new VisException("The visualisation protocol version is not supported.");
                }
                ++n;
            }
            this.clientName = new Atom(this.eclipse.getPeerName().functor() + "_jvc_" + n);
        }
    }

    private void initialiseStreams() throws IOException, EclipseException {
        String string = this.eclipse.getPeerName().functor() + "_jvc_viewables";
        this.viewables_stream_name = this.findUnusedStreamName(string);
        this.viewables_stream = this.eclipse.getFromEclipseQueue(this.viewables_stream_name);
        this.viewables_stream.setListener((QueueListener)new ViewablesQL());
        String string2 = this.eclipse.getPeerName().functor() + "_jvc_updates";
        this.updates_stream_name = this.findUnusedStreamName(string2);
        this.updates_stream = this.eclipse.getFromEclipseQueue(this.updates_stream_name);
        this.updates_stream.setListener((QueueListener)new UpdatesQL());
        String string3 = this.eclipse.getPeerName().functor() + "_jvc_interest";
        this.interest_stream_name = this.findUnusedStreamName(string3);
        this.interest_stream = this.eclipse.getToEclipseQueue(this.interest_stream_name);
        this.interest_stream_f = new EXDROutputStream((OutputStream)this.interest_stream);
        this.eclipse.registerMultitask((MultitaskListener)new VisMultitaskListener());
    }

    private String findUnusedStreamName(String string) throws IOException, EclipseException {
        Object var2_2 = null;
        int n = 0;
        while (var2_2 == null) {
            try {
                this.eclipse.rpc("current_stream", (Object)new Atom(string + n));
            }
            catch (Fail fail) {
                return string + n;
            }
            ++n;
        }
        return string + n;
    }

    public ViewerManager getViewerManager() {
        return this.viewerManager;
    }

    protected void recover_ioe(IOException iOException) {
        if (iOException instanceof EclipseTerminatedException) {
            this.viewerManager.errorDialog("The ECLiPSe process which the visualisation\nclient was connected to has terminated.\n\nThe visualisation client will now exit.");
            this.exitError();
        } else if (this.stateModel.getTerminate() && iOException instanceof SocketException) {
            this.exitNormal();
        } else {
            this.viewerManager.errorDialog("The following IOException was raised: \n\n" + String.valueOf(iOException) + "\n\nThe visualisation client will now exit.");
            this.exitError();
        }
    }

    protected void recover_ee(EclipseException eclipseException) {
        this.viewerManager.errorDialog("The following EclipseException was raised: \n\n" + String.valueOf((Object)eclipseException) + "\n\nThe visualisation client will now exit.");
        this.exitError();
    }

    protected void recover_ve(VisException visException) {
        this.viewerManager.errorDialog("The following VisException was raised: \n\n" + String.valueOf(visException) + "\n\nThe visualisation client will now exit.");
        this.exitError();
    }

    protected void recover_re(RuntimeException runtimeException) {
        this.viewerManager.errorDialog("The following RuntimeException was raised: \n\n" + String.valueOf(runtimeException) + "\n\nThe visualisation client will now exit.");
        this.exitError();
    }

    protected void exitError() {
        if (this.stateModel.getCanPerformRPC()) {
            this.endMultitaskPhase();
        }
    }

    protected void exitNormal() {
        if (this.stateModel.getCanPerformRPC()) {
            this.endMultitaskPhase();
        }
    }

    private void terminate() {
        try {
            this.interest_stream_f.write((Object)terminateAtom);
            this.interest_stream_f.flush();
            this.viewables_stream.close();
            this.updates_stream.close();
            this.interest_stream.close();
            this.eclipse.rpc((CompoundTerm)new CompoundTermImpl(":", (Object)vcSupportAtom, (Object)new CompoundTermImpl("vis_client_unregister", (Object)this.clientName)));
            this.exitNormal();
        }
        catch (EclipseException eclipseException) {
            this.recover_ee(eclipseException);
        }
        catch (IOException iOException) {
            this.recover_ioe(iOException);
        }
    }

    void endMultitaskPhase() {
        try {
            this.eclipse.multitaskTerminate();
        }
        catch (IOException iOException) {
            this.recover_ioe(iOException);
        }
        catch (EclipseException eclipseException) {
            this.recover_ee(eclipseException);
        }
    }

    private class AllCommandsExecuted
    implements Runnable {
        private AllCommandsExecuted() {
        }

        @Override
        public void run() {
            VisClient.this.stateModel.setAllScenarioCommandsExecuted(true);
        }
    }

    private class InterestSpecSynchroniser
    implements PropertyChangeListener {
        private InterestSpec interestSpec;

        InterestSpecSynchroniser(InterestSpec interestSpec) {
            this.interestSpec = interestSpec;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Atom atom = VisClient.this.stateModel.getVisClientName();
            Atom atom2 = this.interestSpec.getViewable().getNameAtom();
            String string = this.interestSpec.getName();
            Atom atom3 = (Atom)propertyChangeEvent.getNewValue();
            CompoundTermImpl compoundTermImpl = new CompoundTermImpl(":", (Object)vcSupportAtom, (Object)new CompoundTermImpl("vis_client_interest_modify", (Object)atom2, (Object)atom, (Object)new Atom(string), (Object)viewGranularityAtom, (Object)atom3));
            try {
                VisClient.this.stateModel.executeMultitaskGoal((CompoundTerm)compoundTermImpl);
            }
            catch (IOException iOException) {
                VisClient.this.recover_ioe(iOException);
            }
            catch (EclipseException eclipseException) {
                VisClient.this.recover_ee(eclipseException);
            }
        }
    }

    private class ViewablesQL
    extends VisEventsQL {
        private ViewablesQL() {
        }

        @Override
        public void dataAvailable(Object object) {
            super.dataAvailable(object);
            if (this.eventTerm.equals((Object)terminateAtom)) {
                VisClient.this.terminate();
                return;
            }
            if (this.eventTerm.equals((Object)visProtocolSupportedAtom)) {
                VisClient.this.protocol_version_supported = true;
                return;
            }
            if (this.eventTerm.functor().equals("vis_protocol_version") && this.eventTerm.arity() == 1) {
                VisClient.this.protocol_version_supported = false;
                return;
            }
            this.parseAndProcess(this.eventTerm);
        }

        private void parseAndProcess(CompoundTerm compoundTerm) {
            VisEvent visEvent = null;
            try {
                CompoundTermImpl compoundTermImpl;
                visEvent = VisEvent.eventFromCompoundTerm(compoundTerm);
                if (visEvent instanceof CreateEvent) {
                    compoundTermImpl = this.sizeGoal(visEvent);
                    ((CreateEvent)visEvent).setViewableSize((List)compoundTermImpl.argCT(2).arg(2));
                }
                if (visEvent instanceof SizeEvent) {
                    compoundTermImpl = this.sizeGoal(visEvent);
                    ((SizeEvent)visEvent).setViewableSize((List)compoundTermImpl.argCT(2).arg(2));
                }
            }
            catch (VisException visException) {
                VisClient.this.recover_ve(visException);
            }
            try {
                VisClient.this.processEvent(visEvent);
            }
            catch (RuntimeException runtimeException) {
                VisClient.this.recover_re(runtimeException);
            }
        }

        private CompoundTermImpl sizeGoal(VisEvent visEvent) {
            try {
                return (CompoundTermImpl)VisClient.this.eclipse.rpc((CompoundTerm)new CompoundTermImpl(":", (Object)vcSupportAtom, (Object)new CompoundTermImpl("viewable_size", (Object)new Atom(visEvent.getViewableName()), null)));
            }
            catch (EclipseException eclipseException) {
                VisClient.this.recover_ee(eclipseException);
            }
            catch (IOException iOException) {
                VisClient.this.recover_ioe(iOException);
            }
            return null;
        }
    }

    private class UpdatesQL
    extends VisEventsQL {
        private UpdatesQL() {
        }

        @Override
        public void dataAvailable(Object object) {
            super.dataAvailable(object);
            VisEvent visEvent = null;
            try {
                visEvent = UpdateEvent.parseFromCompoundTerm(this.eventTerm);
            }
            catch (VisException visException) {
                VisClient.this.recover_ve(visException);
            }
            try {
                VisClient.this.processEvent(visEvent);
            }
            catch (RuntimeException runtimeException) {
                VisClient.this.recover_re(runtimeException);
            }
        }
    }

    private class VisMultitaskListener
    implements MultitaskListener {
        private VisMultitaskListener() {
        }

        public void starting(EclipseMultitaskConnection eclipseMultitaskConnection, String string) {
            if (VisClient.this.stateModel.getTerminate()) {
                VisClient.this.terminate();
            }
            VisClient.this.stateModel.setCanPerformRPC(true);
            if (VisClient.MULTITASK_PHASE_TYPE.equals(string) && (VisClient.this.viewerManager.shouldHold() || VisClient.this.stateModel.getInterrupt())) {
                try {
                    VisClient.this.eclipse.multitaskConfirm();
                }
                catch (IOException iOException) {
                    VisClient.this.recover_ioe(iOException);
                }
                catch (EclipseException eclipseException) {
                    VisClient.this.recover_ee(eclipseException);
                }
            }
        }

        public void ending(EclipseMultitaskConnection eclipseMultitaskConnection, String string) {
            if (VisClient.this.stateModel.getTerminate()) {
                VisClient.this.terminate();
            }
            VisClient.this.stateModel.setCanPerformRPC(false);
            if (VisClient.MULTITASK_PHASE_TYPE.equals(string)) {
                VisClient.this.stopEvent();
            }
        }
    }

    private abstract class VisEventsQL
    implements QueueListener {
        protected CompoundTerm eventTerm;
        EXDRInputStream eis = null;

        private VisEventsQL() {
        }

        public void dataAvailable(Object object) {
            if (this.eis == null) {
                FromEclipseQueue fromEclipseQueue = (FromEclipseQueue)object;
                this.eis = new EXDRInputStream((InputStream)fromEclipseQueue);
            }
            try {
                this.eventTerm = (CompoundTerm)this.eis.readTerm();
            }
            catch (IOException iOException) {
                VisClient.this.recover_ioe(iOException);
            }
        }

        public void dataRequest(Object object) {
        }
    }
}

